########################################################################
#' @descricao Leitura dos dados da pesquisa DataSenado e
# exemplo de calculo de estimativas pontuais considerando o delineamento amostral 
#' @author DataSenado
#' @date   10/22
#' @Pesquisa Barometro Dez 2016
########################################################################

rm(list = ls())

## Pacotes ------------

library(pacman) # Checa se um pacote esta instalado e, em caso afirmativo, faz a carga. Caso contrario, instala e faz a carga em seguida.

pacman::p_load(readxl, tidyverse, survey, purrr)

## diretorios dos arquivos ------------

dir = dirname(rstudioapi::getSourceEditorContext()$path) # diretorio em que o codigo esta salvo

## Microdado ####

df = read.csv2(list.files(dir, ".csv", ignore.case = T,full.names = T), 
               sep = ";")

names(df)

## Criar o estrato (VD_TIPOTEL + regiao (P02)) ------------

df = df %>% 
  mutate(
    estrato = paste0(VD_TIPOTEL, "_", P02)
  )

## Delineamento amostral ------------
data.svy <-
  svydesign(
    id = ~ ID,
    weights = as.numeric(df$W2),
    data = df,
    strata = df$estrato
  )

## Exemplo de estimativa da proporcao ------------
(tab <- svymean(~ as.factor(P02), data.svy))

## Margem de erro da estimativa da proporcao com nivel de confianca de 95% ------------
round((qt(0.975,df = degf(data.svy))*SE(tab))*100,1)

## Exemplo de estimativa dos totais populacionais ------------
svytotal( ~ as.factor(P04), data.svy)

## Exemplo de tabela cruzada ------------
a = svyby( ~ as.factor(P04), ~ as.factor(P02), data.svy, svymean)
t(a)

